/* 
*	ֲWatcomC++,1999414
*
*/

#include <malloc.h>
#include <string.h>
#include "bitmap.hpp"
#include "gl.h"


PixelInfo pixelInfo16 = {
	0xf80000,  // Red mask in color ( color's type : int )
	8,		// how many bits to shift right to convert color(int) to the actual pixel value 
	0xf800,		// the Red value in pixel
	11,			// how many bits to shift right to get Red value from pixel
	0xf800,	// Green
	5,
	0x7e0,
	5,
	0xf8,	  // Blue
	3,
	0x1f,
	0 };
	
PixelInfo pixelInfo15 = {
	0xf80000,	//Red
	9,
	0x7c0,
	10,
	0xf800,		//Green
	5,
	0x3e,
	5,
	0xf8,		//Blue
	3,
	0x1f,
	0 };

Bitmap* Bitmap16::ConvertFormat( int colordepth )
{
	int i, j;
	short* p;
	Bitmap* temp;

	switch( colordepth ){
	case 15:
		temp = new Bitmap15;
		if( temp == NULL )
			return NULL;
		for( i=0; i<height; i++ ){
			p = (short*)line[i];
			for( j=0; j<width; j++, p++ )
				*p = ((*p & 0xffe0) >> 1) | (*p & 0x1f);
		}
		temp->pitch = pitch;
		temp->colorKey = ((colorKey & 0xffe0) >> 1) | (colorKey & 0x1f);
		temp->color = ((color & 0xffe0) >> 1) | (color & 0x1f);
		temp->line = line;
		temp->dat = dat;
		line = NULL;
		dat = NULL;
		break;
	case 16:
		return this;
	default:
		return NULL;
	}
	temp->width = width;
	temp->height = height;
	temp->colorDepth = colordepth;
	temp->clip = clip;
	temp->cl = cl;
	temp->cr = cr;
	temp->ct = ct;
	temp->cb = cb;
	delete this;

	return temp;
}

Bitmap* Bitmap15::ConvertFormat( int colordepth )
{
	int i, j;
	short* p;
	Bitmap* temp;

	switch( colordepth ){
	case 16:
		temp = new Bitmap16;
		if( temp == NULL )
			return NULL;
		
		for( i=0; i<height; i++ ){
			p = (short*)line[i];
			for( j=0; j<width; j++, p++ )
				*p = ((*p & 0x7fe0) << 1) | (*p & 0x1f);
		}
		temp->pitch = pitch;
		temp->colorKey = ((colorKey & 0x7fe0) << 1) | (colorKey & 0x1f);
		temp->color = ((color & 0x7fe0) << 1) | (color & 0x1f);
		temp->line = line;
		temp->dat = dat;
		line = NULL;
		dat = NULL;
		break;

	case 15:
		return this;

	default:
		return NULL;
	}

	temp->width = width;
	temp->height = height;
	temp->colorDepth = colordepth;
	temp->clip = clip;
	temp->cl = cl;
	temp->cr = cr;
	temp->ct = ct;
	temp->cb = cb;
	delete this;

	return temp;
}
